<?php
require_once '../../../core/init.php'; // ✅ Correct path from /actions/admin/

if (!isset($_POST['agent_id'], $_POST['date'])) {
    die("❌ Missing agent_id or date");
}

$agentId = intval($_POST['agent_id']);
$date = $_POST['date']; // Format: Y-m-d

$from = $date . "T00:00:00";
$to = date("Y-m-d", strtotime("$date +1 day")) . "T00:00:00";

// Fetch the agent from database
$res = $conn->prepare("SELECT * FROM submerchants WHERE cycle_agent_id = ?");
if (!$res) {
    die("❌ SQL prepare failed (agent lookup): " . $conn->error);
}
$res->bind_param("i", $agentId);
$res->execute();
$agentResult = $res->get_result();

if ($agentResult->num_rows === 0) {
    die("❌ Agent not found");
}

$agent = $agentResult->fetch_assoc();

// Fetch transactions from Cycle API
$cycle = new CycleAPI();
$txs = $cycle->getAgentTransactionsByHistoryEx($agentId, $from, $to);

$total = $fee = $net = 0;
$tx_ids = [];

foreach ($txs as $tx) {
    if (($tx['Substate'] ?? null) == 411) { // ✅ Only successful payments
        $amt = $tx['Amount'];
        $f = $amt * ($agent['fee_percent'] / 100);
        $total += $amt;
        $fee += $f;
        $net += ($amt - $f);
        $tx_ids[] = $tx['ID'];
    }
}

if (empty($tx_ids)) {
    die("❌ No successful transactions found for this agent on this date.");
}

// Prepare settlement record
$period_start = $date . " 00:00:00";
$period_end = $date . " 23:59:59";
$status = "Time to Settle"; // ✅ Default settlement status
$payout_reference = strtoupper(uniqid('PAYOUT_'));
$jsonTx = json_encode($tx_ids);

// Insert into settlements table
$stmt = $conn->prepare("INSERT INTO settlements (submerchant_id, period_start, period_end, total_amount, total_fees, net_payout, payout_status, payout_date, linked_transactions, payout_reference) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), ?, ?)");
if (!$stmt) {
    die("❌ SQL prepare failed (insert settlement): " . $conn->error);
}
$stmt->bind_param("issddssss", 
    $agent['id'], 
    $period_start, 
    $period_end, 
    $total, 
    $fee, 
    $net, 
    $status, 
    $jsonTx, 
    $payout_reference
);
$stmt->execute();

if ($stmt->affected_rows > 0) {
    // ✅ Success! Redirect nicely back to settlements page
    header("Location: ../settlements.php?success=1&from=$date&to=$date");
    exit;
} else {
    die("❌ Failed to insert settlement record: " . $stmt->error);
}
?>
